# Credits and Related

Much of the heavy lifting in tjot is through dependency libries. Among these:

- [go-term-text](https://github.com/MichaelMure/go-term-text) provides word wrapping and line padding
- [chroma](https://github.com/alecthomas/chroma) provides the code lexer and colorizing
- [pixterm](https://github.com/eliukblau/pixterm) provides image rasterization
- [godjot](https://github.com/sivukhin/godjot) provides djot parsing
- [oksvg](https://github.com/srwiley/oksvg) provides SVG to raster conversion

and of course all of the indirect libraries those dependencies use.

There are countless giants that should be listed, that we all take so much for
despite being unknown to many of us. I'd like to call out a
few projects upon which I heavily lean for development.

- [Helix](https://helix-editor.com/) - a modern, fast editor this a vi-like
  modal paradigm and advanced features like multi-range selects.
- [Go](https://golang.org)
- [gopls](https://github.com/golang/tools/tree/master/gopls), the Really Very
  Good Go language server.
- [delve](https://github.com/go-delve/delve), Go's defacto standard debugger. It
  has a GUI, even, if you're into that sort of thing.
- [Mercurial](https://mercurial-scm.org) - still the best VCS. I spend a lot of
  time in git, and while Jujutsu makes git suck less, it's still not quite
  Mercurial.
- [Gnupg](https://gnupg.org)
- [ripgrep](https://github.com/BurntSushi/ripgrep) - while it's currently
  popular to write replacements for the old POSIX toolset, ripgrep is really the
  only one that vastly improves over the original enough to switch.
- and Linux, X, herbstluftwm, zsh, the entire standard Linux POSIX-ish
  toolkit.

I also advocate the following tools as being Extremely Useful and Sometimes
Indispensible™ to the development process:

- [Sourcehut](https://sr.ht) - it's not free, but it's also not bloated with
  Javascript and CSS, and it still supports Mercurial repositories. It offers
  everything an OSS project could need - lists, tickets, a really nice CI
  system, homepage-like Project containers. It's inexpensive, especially for
  what you get, but if anything more than $0 is too expensive, it's also OSS
  -- you can download every component and host it yourself; what you're really
  paying for is the hosting.
- [revive](https://revive.run) - a much nicer alternative to golint
- [csvtk](https://github.com/shenwei356/csvtk) - a strange entry for a dev tool
  list, but I use this thing All. The. Time. It's part of the CI. CSV is still
  one of the best semi-structured document formats, far less bloated than JSON
  (which is already pretty light). It's indispensible in my build CI.
- [go-licenses](https://github.com/google/go-licenses) - if you have to have dependencies, tools like this become important. It's a license jungle out there.
- [scc](https://github.com/boyter/scc). I've used a lot of different LOC
  counters; scc is nice because it also does some complexity calculations,
  generates CSV, can disable the pretty-printing, is multi-threaded, can
  calculate DRY metrics, respects .ignore files, can identify generated and
  minified files, count duplicated LOC... it is a very versatile tool.
- [govulncheck](https://pkg.go.dev/golang.org/x/tools/gopls/internal/vulncheck/govulncheck) -
  Increasingly imortant; it doesn't cover all of the security risks, but it
  helps.
- [markdownlinkchecker](https://github.com/becheran/mlc) - I _just_ discovered
  this when a user brought a broken link in a README to my attention. I went
  through and checked all of my projects and found a distressing number of
  broken links -- and discovered an overly-restrictive firewall rule on one of
  my servers that was preventing access to a service! So I'm currently extremely
  grateful for this tool.
- [shields.io](https://shields.io) - provides a really valuable, free service
  for generating badges (as used at the top of this readme). I can't thank them
  enough. My CI process uses their service at build time and generates static
  versions to reduce load on their service.

tjot is developed using a set of decentralized, CLI-based tools. Web
tools are fine, and they're sometimes necessary, but they centralize data, are
hard to script, and just generally get in my way. When there are many people
from different domains collaborating on a thing, this extra impediment is
necessary; when there aren't, it's not. I use code comments for issue tracking
and [legume](https://ser1.net/legume) to make that easier to view and I
use [changelog](https://ser1.net/changelog) to generate the
[CHANGELOG.md](https://ser1.net/tjot/browse/CHANGELOG.md?rev=tip).
