# tjot

A colorize [djot](https://djot.net) terminal pager.

[![Build status](https://builds.sr.ht/~ser/tjot/.build.yml.svg)](https://builds.sr.ht/~ser/tjot/.build.yml?)
★ [Releases](https://downloads.ser1.net/software/tjot/)
★ ![Latest release](https://downloads.ser1.net/software/tjot/badges/latest_release.svg)  
[License](https://ser1.net/tjot/raw/LICENSE?rev=tip)
★ [Changelog](https://ser1.net/tjot/browse/CHANGELOG.md?rev=tip)
★ [Software metrics](https://downloads.ser1.net/software/tjot/badges/METRICS.md)
★ [Issues](https://todo.sr.ht/~ser/tjot)
★ [Mailing List](https://lists.sr.ht/~ser/tjot)
★ [Credits](https://ser1.net/tjot/browse/CREDITS.md?rev=tip)  
[![Go Report Card](https://goreportcard.com/badge/ser1.net/tjot)](https://goreportcard.com/report/ser1.net/tjot)
★ ![Code linting](https://downloads.ser1.net/software/tjot/badges/linting.svg)
★ ![Code security](https://downloads.ser1.net/software/tjot/badges/vulnerabilities.svg)
★ ![Unit tests](https://downloads.ser1.net/software/tjot/badges/unit_tests.svg)  
![Code coverage](https://downloads.ser1.net/software/tjot/badges/coverage.svg)
★ ![Code complexity](https://downloads.ser1.net/software/tjot/badges/complexity.svg)
★ ![ABC metrics](https://downloads.ser1.net/software/tjot/badges/abc_score.svg)
★ ![Lines of code](https://downloads.ser1.net/software/tjot/badges/loc.svg)

A terminal renderer for djot documents. The project is considered alpha-quality:
there are known bugs and many missing features. See the end of the
[changelog](https://ser1.net/tjot/browse/CHANGELOG.md?rev=tip) for a list.

- [Features](#features)
- [Usage](#usage)
- [Install](#install)
- [To-do & known bugs](https://ser1.net/tjot/browse/CHANGELOG.md#todo?rev=tip)
- [Other solutions](#other-solutions)

## Features

![](https://ser1.net/tjot/raw/screen.png?rev=tip)

- Covers 100% of the Djot spec
- Reasonably fast:

  - `pandoc -f djot -t ansi`: 10 runs, milliseconds: [266, σ 270, 274]
  - `tjot`: 105 runs, [24, σ 26, 28]

- ANSI glyphs & escape codes for nice tables, task lists, and coloring
- Renders images, including SVGs
- Detects the terminal size (usually) for accurate wrapping
- Langage-sensitive highlighting for code blocks, and language detection

### Limitations & Caveats

#### No image caching

If tjot seems slow at times, check if your document contains embedded, remote
images. tjot tries to fetch and render these; for example, the top table in
`tests/README.dj` pauses at the start because it's downloading 11 badges. tjot
does no image caching (yet), and so this image fetching happens every time you
run tjot.

To disable remote images and skip them, use the `-n` flag.

#### No built-in pager (yet)

Use `less -r`.

Because there are no pages, footnotes are rendered as endnotes.

#### No persistent configuration

There's no configuration yet. Eventually you'll be able to disable image
fetching, image rendering, image rastering methods, and swap colors around, but
this is TBI.

#### Super/sub-scripts are poorly supported

Unicode does not have a specific code space for super- and sub-scripts. There
are defined code points for glyphs which look like super- and sub-scripts;
however, this is limited (this set of glyphs does not cover the latin
alphanumeric space), and not all fonts support them. Results can be erratic.
This version of tjot has no work- around for this -- if you render a document
with super/sub-script markup, you may get emojis or other odd characters in the
output. To print a list of supported super and subscripts, run `tjot -s`. Add
`-v` to see the glyphs in your terminal, and check that they're mapped
correctly. If they aren't, there's not much you can do about it except change
your terminal font or skip the wrong ones.

#### Additionally...

See the end of the [changelog](CHANGELOG.md) for other known bugs and
limitations.

## Usage

`tjot -h` will give you usage.

Either provide a file path to the program, or pipe the content to it.

```sh
$ tjot my_document.dj
$ <my_document.dj tjot
```

tjot will attempt to detect the terminal width. If you pipe the output to a file,
this may fail, and the width will be defaulted to 75 columns; you can always use
`-w` to manually override the detected/default width. If you pipe to `less -r`,
not only will styling be correctly rendered, but width detection should also
work.

tjot does (not yet) have a built-in pager. `tjot ... | less -r` works well. For
other pages, use whatever "pass-through raw control characters" it provides to
achieve the same results.

tjot will attempt to download and render any images in the document which are
referred to by URL. This can cause rendering to be slow; tjot does (not yet)
provide caching, so this fetching will happen every time the document is
displayed. The remote image-fetching can be disabled with the `-n` flag, which
will result in remote images being skipped.

## Install

1. Download one of the pre-built binaries from the
   [releases](https://downloads.ser1.net/software/tjot/) page.
2. If you have Go installed, run `go install ser1.net/tjot@latest`. Make sure
   you have `$(go env GOPATH)/bin` in your `${PATH}`.
3. Clone the repository, build it, and copy the binary into your `${PATH}`

   ```sh
   $ hg clone ser1.net/tjot
   $ cd tjot
   $ go build .
   $ cp tjot /usr/local/bin
   ```

tjot needs changes to the godjot library which have not yet been merged
upstream. For now there's a `replace` directive in the `go.mod`.

## Other solutions

```sh
pandoc -f djot -t ansi <file>.dj
```

## Benchmark history

- goos: linux
- goarch: amd64
- pkg: ser1.net/tjot/term
- cpu: AMD Ryzen 7 5800H with Radeon Graphics

### v0.0.5: 

```
BenchmarkRenderer-16                1114           1087711 ns/op
```
